-- 
use bd_air_france;

IF OBJECT_ID ('dbo.T_Compagnie_cmp','U') IS NOT NULL
    DROP TABLE dbo.T_Compagnie_cmp;
GO

CREATE TABLE T_Compagnie_cmp
(cmp_id          INT PRIMARY KEY IDENTITY, 
 cmp_pays        VARCHAR(3),
 cmp_contenu_XML XML);

-- insertion 

INSERT INTO T_Compagnie_cmp(cmp_pays,cmp_contenu_XML)
VALUES ('fr',
'<?xml version="1.0" encoding="ISO-8859-1"?>
  <compagnie>
  <comp>AC</comp>
   <pilotes>
     <pilote brevet="PL-3">
     <nom>B. Duffaut</nom>
     <salaire>5000</salaire>
   </pilote>
   <pilote brevet="PL-4">
     <nom>P. Minier</nom>
   </pilote>
  </pilotes>
  <nomComp>Castanet Lines</nomComp>
</compagnie>');

INSERT INTO T_Compagnie_cmp(cmp_pays,cmp_contenu_XML)
SELECT 'fr', doc
FROM   (SELECT * FROM OPENROWSET 
           (BULK 'C:\Donnees\dev\ms\xml\compagnie.xml', SINGLE_BLOB) 
       AS doc) AS Document(doc);

-- modifs

UPDATE T_Compagnie_cmp
SET    cmp_contenu_XML.modify('       
          insert <pilote brevet="PL-4b"><nom>D. Vacher</nom></pilote>
          as last into (/compagnie/pilotes) [1]')
WHERE  cmp_id=1;

-- modif du salaire du brevet="PL-2"

UPDATE T_Compagnie_cmp
SET    cmp_contenu_XML.modify('replace value of
      (/compagnie/pilotes/pilote[@brevet="PL-2"]/salaire/text()) [1] with "600"')
WHERE  cmp_id=2;

UPDATE T_Compagnie_cmp
SET    cmp_contenu_XML.modify('delete
           (/compagnie/pilotes/pilote[nom/text()="D. Vacher"]) [1]')
WHERE  cmp_id=1;

-- extractions

SELECT cmp_contenu_XML.query('/compagnie/pilotes/pilote/nom')
       AS "/compagnie/pilotes/pilote/nom"
FROM   T_Compagnie_cmp
WHERE  cmp_id=1;

SELECT cmp_contenu_XML.query('data(/compagnie/pilotes/pilote/nom)')
       AS "data(/compagnie/pilotes/pilote/nom)"
FROM   T_Compagnie_cmp
WHERE  cmp_id=2;

SELECT cmp_id,cmp_pays,
       cmp_contenu_XML.query('/compagnie/pilotes/pilote[@brevet="PL-1"]/nom') AS "PL-1"
FROM   T_Compagnie_cmp;

-- value

SELECT cmp_contenu_XML.value
    ('sum(/compagnie/pilotes/pilote/salaire) [1]', 'INT')
    AS "sum(/compagnie/pilotes/pilote/salaire)"
FROM   T_Compagnie_cmp
WHERE  cmp_id=1;

SELECT cmp_contenu_XML.value
    ('(/compagnie/pilotes/pilote/@brevet[../nom="P. Minier"]) [1]', 'VARCHAR(6)')
    AS "@brevet[../nom='P. Minier']"
FROM   T_Compagnie_cmp
WHERE  cmp_id=1;

-- exist

SELECT cmp_id,
    cmp_contenu_XML.query('/compagnie/pilotes/pilote/salaire[number()>3500]/../nom') AS "pilote"
FROM   T_Compagnie_cmp
WHERE  cmp_contenu_XML.exist('/compagnie/comp[text()="AB"]') = 1
OR     cmp_contenu_XML.exist('/compagnie/comp[text()="AC"]') = 1;

SELECT cmp_id,
    cmp_contenu_XML.query('/compagnie/nomComp/text()') AS "compagnie",
    cmp_contenu_XML.value
    ('count(/compagnie/pilotes/pilote) [1]', 'INT') AS "effectif"
FROM   T_Compagnie_cmp
WHERE  cmp_contenu_XML.exist('/compagnie/pilotes/pilote/salaire[number()>3500]') = 1;


-- nodes

INSERT INTO T_Compagnie_cmp(cmp_pays,cmp_contenu_XML)
VALUES ('fr',
'<compagnie>
  <comp>AF</comp>
   <pilotes>
     <pilote brevet="PL-5">
     <nom>A. Randria</nom>
     <salaire>7000</salaire>
     <vols>
     <vol>01/12/2010</vol>
     <vol>02/12/2010</vol>
     <vol>03/12/2010</vol>
     </vols>
   </pilote>
   <pilote brevet="PL-6">
     <nom>B. Evrard</nom>
     <salaire>6500</salaire>
     <vols>
      <vol>01/12/2010</vol>
      <vol>05/12/2010</vol>
     </vols>
   </pilote>
  </pilotes>
  <nomComp>Air France</nomComp>
</compagnie>');

-- 1 noeud de dpart

SELECT      t.col.value('../@brevet', 'VARCHAR(6)') AS "brevet",
            t.col.value('.', 'VARCHAR(20)') AS "nom",
            t.col.query('../salaire') AS "salaires",
            cmp_id
FROM        T_Compagnie_cmp
CROSS APPLY cmp_contenu_XML.nodes('/compagnie/pilotes/pilote/nom') AS t(col)
ORDER BY 2;

-- 3 noeuds de dpart

SELECT      t.col.value('.','VARCHAR(20)') AS ".", cmp_id
FROM        T_Compagnie_cmp
CROSS APPLY cmp_contenu_XML.nodes(' /compagnie/nomComp, /compagnie/pilotes/pilote/nom, /compagnie/pilotes/pilote/salaire') AS t(col)
WHERE       cmp_id=1 OR cmp_id=2;

-- plusieurs niveaux 

SELECT      t1.c1.value('../@brevet', 'VARCHAR(6)') AS "brevet",
            t1.c1.value('.','VARCHAR(20)') AS "nom", 
            t2.c2.value('.','VARCHAR(10)') AS "vol"
FROM        T_Compagnie_cmp
CROSS APPLY cmp_contenu_XML.nodes('/compagnie/pilotes/pilote/nom') AS t1(c1)
CROSS APPLY t1.c1.nodes('../vols/vol') AS t2(c2)
WHERE       cmp_id=3;

-- PL4 remonte pas (absence salaire)

SELECT      t2.col2.value('.', 'VARCHAR(6)') AS "brevet",
            t.col.value('.', 'VARCHAR(20)') AS "nom",
            t3.col3.value('.', 'INT') AS "salaire"
FROM        T_Compagnie_cmp
CROSS APPLY cmp_contenu_XML.nodes('/compagnie/pilotes/pilote/nom') AS t(col)
CROSS APPLY t.col.nodes('../@brevet') AS t2(col2)
CROSS APPLY t.col.nodes('../salaire') AS t3(col3);

-- index

--primaire

CREATE PRIMARY XML INDEX IX_Compagnie_contenu_XML
ON     T_Compagnie_cmp(cmp_contenu_XML); 

--secondaires

-- PATH 

CREATE XML INDEX IX_Compagnie_Path_XML
ON     T_Compagnie_cmp(cmp_contenu_XML)
USING XML INDEX IX_Compagnie_contenu_XML
FOR PATH;

SELECT cmp_id,
    cmp_contenu_XML.query('/compagnie/nomComp/text()') AS "compagnie",
    cmp_contenu_XML.value
    ('count(/compagnie/pilotes/pilote) [1]', 'INT') AS "effectif"
FROM   T_Compagnie_cmp
WHERE  cmp_contenu_XML.exist('/compagnie/pilotes/pilote/salaire[number()>3500]') = 1;


-- PROPERTY

CREATE XML INDEX IX_Compagnie_Property_XML
ON     T_Compagnie_cmp(cmp_contenu_XML)
USING XML INDEX IX_Compagnie_contenu_XML
FOR PROPERTY;

SELECT cmp_contenu_XML.value
    ('(/compagnie/pilotes/pilote/@brevet[../nom="P. Minier"]) [1]', 'VARCHAR(6)')
    AS "@brevet[../nom='P. Minier']"
FROM   T_Compagnie_cmp
WHERE  cmp_id=1;

--- namespaces

INSERT INTO T_Compagnie_cmp(cmp_pays,cmp_contenu_XML)
VALUES ('uk',
'<?xml version="1.0" encoding="ISO-8859-1"?>
  <compagnie xmlns="www.british-air.com">
  <comp>BA</comp>
   <pilotes>
     <pilote brevet="PL-7">
     <nom>B. Meleton</nom>
     <salaire>4700</salaire>
   </pilote>
   <pilote brevet="PL-8">
     <nom>P. Filloux</nom>
     <salaire>6200</salaire>
   </pilote>
  </pilotes>
  <nomComp>British Air</nomComp>
</compagnie>');

-- query ok

WITH XMLNAMESPACES ('www.british-air.com' AS p)
SELECT cmp_contenu_XML.query('/p:compagnie/p:pilotes/p:pilote/p:nom')
       AS "p:nom", cmp_id
FROM   T_Compagnie_cmp;

-- value ok

WITH XMLNAMESPACES ('www.british-air.com' AS p)
SELECT cmp_id, 
       cmp_contenu_XML.value ('(/p:compagnie/p:pilotes/p:pilote/p:nom)[1]', 'VARCHAR(20)')
       AS "premier pilote"
FROM   T_Compagnie_cmp;

-- nodes ok

WITH XMLNAMESPACES ('www.british-air.com' AS p)
SELECT      t.col.query('./p:nom') AS "p:nom", 
           cmp_id
FROM        T_Compagnie_cmp
CROSS APPLY cmp_contenu_XML.nodes('/p:compagnie/p:pilotes/p:pilote') AS t(col);

WITH XMLNAMESPACES ('www.british-air.com' AS p)
SELECT      t.col.query('data(./p:nom)') AS "p:nom", cmp_id
FROM        T_Compagnie_cmp
CROSS APPLY cmp_contenu_XML.nodes('/p:compagnie/p:pilotes/p:pilote') AS t(col);

WITH XMLNAMESPACES ('www.british-air.com' AS p)
SELECT    cmp_id,
          t.col.value('.', 'VARCHAR(20)') AS "nom",
            t.col.value('(../p:salaire)[1]','INT') AS "salaire"
FROM        T_Compagnie_cmp
CROSS APPLY cmp_contenu_XML.nodes('/p:compagnie/p:pilotes/p:pilote/p:nom') AS t(col);

-- plusieurs ns

INSERT INTO T_Compagnie_cmp(cmp_pays,cmp_contenu_XML)
VALUES ('nl',
'<?xml version="1.0" encoding="ISO-8859-1"?>
  <compagnie xmlns="www.kml.com">
  <comp>KLM</comp>
   <pilotes xmlns="www.sky-team.com">
     <pilote brevet="PL-9">
     <nom>B. VanMeer</nom>
     <salaire>3700</salaire>
   </pilote>
   <pilote brevet="PL-10">
     <nom>S. Krot</nom>
     <salaire>2200</salaire>
   </pilote>
  </pilotes>
  <nomComp>Royal Dutch</nomComp>
</compagnie>');


WITH XMLNAMESPACES ('www.kml.com' AS p1, 
                    'www.sky-team.com' AS p2)
SELECT    cmp_id,
          t.col.value('.', 'VARCHAR(20)') AS "nom",
            t.col.value('(../p2:salaire)[1]','INT') AS "salaire"
FROM        T_Compagnie_cmp
CROSS APPLY cmp_contenu_XML.nodes('/p1:compagnie/p2:pilotes/p2:pilote/p2:nom') AS t(col);

WITH XMLNAMESPACES ('www.kml.com' AS p1, 
                    'www.sky-team.com' AS p2,
                     DEFAULT 'www.sky-team.com')
SELECT    cmp_id,
          t.col.value('.', 'VARCHAR(20)') AS "nom",
            t.col.value('(../salaire)[1]','INT') AS "salaire"
FROM        T_Compagnie_cmp
CROSS APPLY cmp_contenu_XML.nodes('/p1:compagnie/pilotes/pilote/nom') AS t(col);


-- Grammaire XML Schema

CREATE XML SCHEMA COLLECTION XSC_compagnie AS 
'<?xml version="1.0" encoding="UTF-8"?>
<xsd:schema attributeFormDefault="unqualified" elementFormDefault="qualified" version="1.0" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
	<xsd:element name="compagnie" type="compagnieType"/>
	<xsd:complexType name="compagnieType">
		<xsd:sequence>
			<xsd:element name="comp" type="xsd:string"/>
			<xsd:element name="pilotes" type="pilotesType"/>
			<xsd:element name="nomComp" type="xsd:string"/>
		</xsd:sequence>
	</xsd:complexType>
	<xsd:complexType name="pilotesType">
		<xsd:sequence>
			<xsd:element minOccurs="1" maxOccurs="2000" name="pilote" type="piloteType"/>
		</xsd:sequence>
	</xsd:complexType>
	<xsd:complexType name="piloteType">
		<xsd:sequence>
			<xsd:element name="nom" minOccurs="1" type="xsd:string"/>
			<xsd:element name="salaire" minOccurs="1" type="xsd:decimal"/>
		</xsd:sequence>
		<xsd:attribute name="brevet" type="xsd:string"/>
	</xsd:complexType>
</xsd:schema>';


IF OBJECT_ID ('dbo.T_Compagnie_cmp','U') IS NOT NULL
    DROP TABLE dbo.T_Compagnie_cmp;
GO

CREATE TABLE T_Compagnie_cmp
(cmp_id          INT PRIMARY KEY IDENTITY, 
 cmp_pays        VARCHAR(3),
 cmp_contenu_XML XML (XSC_compagnie));

--OK

INSERT INTO T_Compagnie_cmp(cmp_pays,cmp_contenu_XML)
SELECT 'fr', doc
FROM   (SELECT * FROM OPENROWSET 
           (BULK 'C:\Donnees\dev\ms\xml\compagnie.xml', SINGLE_BLOB) 
       AS doc) AS Document(doc);

-- PB

INSERT INTO T_Compagnie_cmp(cmp_pays,cmp_contenu_XML)
VALUES ('fr',
'<?xml version="1.0" encoding="ISO-8859-1"?>
  <compagnie>
  <comp>AC</comp>
   <pilotes>
     <pilote brevet="PL-3">
     <nom>B. Duffaut</nom>
     <salaire>5000</salaire>
   </pilote>
   <pilote brevet="PL-4">
     <nom>P. Minier</nom>
   </pilote>
  </pilotes>
  <nomComp>Castanet Lines</nomComp>
</compagnie>');

-- gnrer du contenu

IF OBJECT_ID ('dbo.T_pilotes_pil','U') IS NOT NULL
    DROP TABLE dbo.T_pilotes_pil;
GO

IF OBJECT_ID ('dbo.T_compagnies_cmp','U') IS NOT NULL
    DROP TABLE dbo.T_compagnies_cmp;
GO


CREATE TABLE T_compagnies_cmp
(cmp_comp    VARCHAR(4) PRIMARY KEY,
 cmp_pays    VARCHAR(3),
 cmp_nomcomp VARCHAR(30));

CREATE TABLE T_pilotes_pil
(pil_brevet  VARCHAR(6) PRIMARY KEY,
 pil_nom     VARCHAR(30),
 pil_salaire DECIMAL(7,2),
 cmp_comp    VARCHAR(4) FOREIGN KEY REFERENCES T_compagnies_cmp);

INSERT INTO T_compagnies_cmp
VALUES ('AC','fr','Castanet Lines');

INSERT INTO T_compagnies_cmp
VALUES ('AB','fr','Air Blagnac');


INSERT INTO T_pilotes_pil
VALUES ('PL-1','C. Sigaudes',4000, 'AB');

INSERT INTO T_pilotes_pil
VALUES ('PL-2','P. Filoux',5000, 'AB');

INSERT INTO T_pilotes_pil
VALUES ('PL-3','B. Duffaut',5000, 'AC');

INSERT INTO T_pilotes_pil
VALUES ('PL-4','P. Minier',NULL, 'AC');

-- FOR XML RAW 

SELECT  pil_brevet AS "brevet", pil_nom AS "nom", 
        pil_salaire AS "salaire", cmp_comp AS "comp"
FROM    T_pilotes_pil 
FOR XML RAW;

SELECT  pil_brevet AS "brevet", pil_nom AS "nom", 
        pil_salaire AS "salaire", cmp_comp AS "comp"
FROM    T_pilotes_pil 
FOR XML AUTO, ROOT ('pilotes');

SELECT  pil_brevet AS "brevet", pil_nom AS "nom", 
        pil_salaire AS "salaire", cmp_comp AS "comp"
FROM    T_pilotes_pil WHERE cmp_comp = 'AB'
FOR XML RAW, ELEMENTS XSINIL;

SELECT  pil_brevet AS "brevet", pil_nom AS "nom", 
        pil_salaire AS "salaire", cmp_comp AS "comp"
FROM    T_pilotes_pil  WHERE cmp_comp = 'AC'
FOR XML RAW, ELEMENTS ABSENT;

SELECT  cmp_comp, cmp_pays, cmp_nomcomp 
FROM    T_compagnies_cmp WHERE cmp_comp = 'AC'
FOR XML RAW, 
ROOT ('compagnie')
XMLSCHEMA('www.air-blagnac.fr/xml'), ELEMENTS;

-- FOR XML EXPLICIT

SELECT 1        AS Tag,
       NULL     AS Parent,
       NULL     AS [compagnie!1!!ELEMENT],
       NULL     AS [comp!2!!ELEMENT],
       NULL     AS [pilotes!3!ELEMENT],
       NULL     AS [pilote!4!brevet],
       NULL     AS [nom!5!!ELEMENT],
       NULL     AS [salaire!6!!ELEMENT],
       NULL     AS [nomcomp!7!!ELEMENT]
FROM   T_compagnies_cmp WHERE cmp_comp = 'AC'
UNION
SELECT 2        AS Tag,
       1        AS Parent,
	   NULL,
       cmp_comp,
       NULL,
       NULL,
       NULL,
       NULL,
       NULL
FROM   T_compagnies_cmp WHERE cmp_comp = 'AC'
UNION
SELECT 3 AS Tag,
       1 AS Parent,
	   	NULL,
       cmp_comp,
       NULL,
	   NULL,
       NULL,
	   NULL,
	  NULL
FROM   T_compagnies_cmp WHERE cmp_comp = 'AC'
UNION
SELECT 4   AS Tag,
       3   AS Parent,
       NULL,
	   c.cmp_comp,
       NULL,
       p.pil_brevet,
       NULL,
       NULL,
       NULL
FROM   T_compagnies_cmp c
JOIN   T_pilotes_pil    p
ON     c.cmp_comp = p.cmp_comp
WHERE  c.cmp_comp = 'AC'
UNION
SELECT 5   AS Tag,
       4   AS Parent,
       NULL,
       c.cmp_comp,
       NULL,
       p.pil_brevet,
       p.pil_nom,
       NULL,
       NULL
FROM   T_compagnies_cmp c
JOIN   T_pilotes_pil    p
ON     c.cmp_comp = p.cmp_comp
WHERE  c.cmp_comp = 'AC'
UNION
SELECT 6   AS Tag,
       4   AS Parent,
       NULL,
       c.cmp_comp,
       NULL,
       p.pil_brevet,
       p.pil_nom,
       p.pil_salaire,
       NULL
FROM   T_compagnies_cmp c
JOIN   T_pilotes_pil    p
ON     c.cmp_comp = p.cmp_comp
WHERE  c.cmp_comp = 'AC'
UNION
SELECT 7 AS Tag,
       1 AS Parent,
	   NULL,
       cmp_comp,
       NULL,
	   'ZZZZZZ',
       NULL,
	   NULL,
	   cmp_nomcomp
FROM   T_compagnies_cmp WHERE  cmp_comp = 'AC'
ORDER BY 4,6
FOR XML EXPLICIT;

-- FOR XML PATH

SELECT p.pil_brevet  AS '@brevet',
       p.pil_nom     AS 'nom',
       p.pil_salaire AS 'salaire',
       c.cmp_comp AS 'compagnie/comp',
       c.cmp_nomcomp AS 'compagnie/nomcomp'
FROM   T_compagnies_cmp c
JOIN   T_pilotes_pil    p
ON     c.cmp_comp = p.cmp_comp
WHERE  c.cmp_comp = 'AC'
FOR XML PATH('pilote'), ROOT ('pilotes');

-- 

SELECT p.pil_brevet  AS '@brevet',
       'du texte, contenu mixte !' AS 'text()',
       p.pil_nom     AS 'nom',
       'Compagnie du pilote' AS 'comment()',
       c.cmp_nomcomp AS 'compagnie'
FROM   T_compagnies_cmp c
JOIN   T_pilotes_pil    p
ON     c.cmp_comp = p.cmp_comp
WHERE  c.cmp_comp = 'AC'
AND    p.pil_salaire IS NOT NULL
FOR XML PATH;

-- variables xml

DECLARE @x1 AS XML;
SELECT @x1 =
  (SELECT * FROM OPENROWSET 
      (BULK 'C:\Donnees\dev\ms\xml\compagnie.xml', SINGLE_BLOB) 
  AS doc);
SELECT @x1;

DECLARE @x2 AS XML;
SELECT @x2 = cmp_contenu_XML
       FROM  T_Compagnie_cmp WHERE cmp_id = 1;
SELECT @x2;

DECLARE @x3 AS XML;
SET @x3 = '<?xml version="1.0" encoding="ISO-8859-1"?>
  <compagnie xmlns="www.british-air.com">
  <comp>AC</comp>
   <pilotes>
     <pilote brevet="PL-7">
     <nom>B. Meleton</nom>
     <salaire>4700</salaire>
   </pilote>
   <pilote brevet="PL-8">
     <nom>P. Filloux</nom>
     <salaire>6200</salaire>
   </pilote>
  </pilotes>
  <nomComp>British Air</nomComp>
</compagnie>';

;WITH XMLNAMESPACES ('www.british-air.com' as p)
SELECT  c.value('(p:pilote/p:nom)[1]', 'VARCHAR(40)')
AS      "premier pilote de l'espace"
FROM    @x3.nodes('//p:pilotes') t(c);

DECLARE @x4 AS XML;
SELECT @x4 =
(SELECT p.pil_brevet  AS '@brevet',
       p.pil_salaire AS '@salaire',
       p.pil_nom     AS 'nom',
       c.cmp_comp AS 'compagnie/@comp'
FROM   T_compagnies_cmp c
JOIN   T_pilotes_pil    p
ON     c.cmp_comp = p.cmp_comp
WHERE  p.pil_salaire IS NOT NULL
ORDER BY c.cmp_comp, p.pil_brevet
FOR XML PATH('pilote'), TYPE, ROOT('pilotes'));
SELECT @x4;

-- OPENXML

-- variables locales 

DECLARE @hdoc INT,          -- handle vers document en mmoire 
        @doc VARCHAR(500);  -- document texte simulant le XML 

-- assignation XML 

SET @doc ='
<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
	<comp>AB</comp>
	<pilotes>
		<pilote brevet="PL-1">
			<nom>C. Sigaudes</nom>
			<salaire>4000</salaire>
		</pilote>
		<pilote brevet="PL-3">
			<nom>P. Filloux</nom>
			<salaire>5000</salaire>
		</pilote>
	</pilotes>
	<nomComp>Air Blagnac</nomComp>
</compagnie>';
 
-- mise en mmoire et prparationdu doc XML 

EXEC sp_xml_preparedocument @hdoc OUTPUT, @doc;

SELECT @hdoc;

-- extraction sour forme tabulaire

SELECT *  
FROM  OPENXML(@hdoc,  
        '/compagnie/pilotes/pilote',  
        1)                   
WITH (brevet VARCHAR(6));


CREATE TABLE #TEMP_pilote_tmp
 (tmp_nom  VARCHAR(30), 
  tmp_salaire DECIMAL(7,2));

INSERT INTO #TEMP_pilote_tmp
SELECT *  
FROM  OPENXML(@hdoc,  
        '/compagnie/pilotes/pilote', 
        2)                
WITH (nom     VARCHAR(30), 
      salaire DECIMAL(7,2));

SELECT * FROM #TEMP_pilote_tmp;
 
SELECT *  
FROM  OPENXML(@hdoc,  
        '/compagnie/pilotes/pilote', 
        2);

-- suppression du doc en mmoire  
          
EXEC sp_xml_removedocument @hdoc;

-- nettoyage 

IF OBJECT_ID ('dbo.T_Compagnie_cmp','U') IS NOT NULL
    DROP TABLE dbo.T_Compagnie_cmp;
GO

IF OBJECT_ID ('dbo.T_pilotes_pil','U') IS NOT NULL
    DROP TABLE dbo.T_pilotes_pil;
GO

IF OBJECT_ID ('dbo.T_compagnies_cmp','U') IS NOT NULL
    DROP TABLE dbo.T_compagnies_cmp;
GO